﻿//////////////////////////////////////////////
// UnitTester.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestClass ;
}

/// Includes ---------------------------------

// nkDebug
#include "../Dll/DllDefines.h"

#include "TestRunParameters.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT UnitTester final
	{
		public :

			// Functions
			// Registering
			static TestClass* registerTestClass (std::function<TestClass* ()> factoryFunction) ;
			static nkMemory::BufferCast<TestClass*> getRegisteredClasses (nkMemory::StringView filter = "") ;
			static unsigned int getRegisteredTestClassCount () ;

			// Run
			static void run (const TestRunParameters& parameters = TestRunParameters()) ;

			// Utils
			static nkMemory::BufferCast<TestClass*> getAllTests () ;
	} ;
}